<?php
require 'db.php';
$success = '';
$error = '';

if (isset($_GET['token'])) {
    $token = $_GET['token'];

    $stmt = $conn->prepare("SELECT id FROM users WHERE verification_token=? AND is_verified=0");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $stmt->close();
        $update = $conn->prepare("UPDATE users SET is_verified=1, verification_token=NULL WHERE verification_token=?");
        $update->bind_param("s", $token);
        $update->execute();
        $update->close();

        $success = "Email verified successfully! You can now login.";
    } else {
        $error = "Invalid or expired verification link.";
    }
} else {
    $error = "No token provided.";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Email Verification</title>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
body { font-family:'Poppins',sans-serif; background: rgb(23,35,58); color:white; display:flex; justify-content:center; align-items:center; min-height:100vh; }
</style>
</head>
<body>

<script>
<?php if(!empty($success)): ?>
Swal.fire({
    icon: 'success',
    title: 'Success!',
    html: '<?php echo $success; ?> <br><a href="../login.php" style="color:#F5A425;">Login</a>',
    showConfirmButton: true
});
<?php endif; ?>

<?php if(!empty($error)): ?>
Swal.fire({
    icon: 'error',
    title: 'Oops!',
    html: '<?php echo $error; ?>',
    showConfirmButton: true
});
<?php endif; ?>
</script>

</body>
</html>
