<?php
session_start();
include "db.php";

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Get courses the user purchased
$courses = $conn->query("
    SELECT DISTINCT c.id, c.title
    FROM user_payments p
    INNER JOIN courses c ON p.course_id = c.id
    WHERE p.user_id = '$user_id'
");

$courseList = [];
while ($c = $courses->fetch_assoc()) {
    $courseList[$c['id']] = $c['title'];
}

if (empty($courseList)) {
    die("<p style='text-align:center; margin-top:50px;'>No updates available.</p>");
}

// Fetch updates for all courses the user purchased
$courseIds = implode(",", array_keys($courseList));
$updates = $conn->query("
    SELECT *
    FROM course_updates
    WHERE course_id IN ($courseIds)
    ORDER BY course_id, created_at DESC
");

// Organize updates by course
$updatesByCourse = [];
while ($u = $updates->fetch_assoc()) {
    $updatesByCourse[$u['course_id']][] = $u;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Your Course Updates</title>
<style>
:root {
    --primary-color: rgb(245,164,37);
    --bg: rgb(31,44,56);
    --card: #2a2a44;
    --text: #fff;
    --muted: #ccc;
    --border: #444;
}
body.dark {
    --bg: rgb(15,23,42);
    --card: #fff;
    --text: #222;
    --muted: #666;
    --border: #ddd;
}
body {
    margin:0;
    font-family: "Segoe UI", sans-serif;
    background: rgb(15,23,42);
    color: var(--text);
    padding: 20px;
    transition:0.3s;
}

/* Topbar */
.topbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 30px;
    flex-wrap: wrap;
}
.topbar .logo img {
    height: 90px;
    max-width: 100%;
    border-radius: 12px;
    /*box-shadow: 0 4px 12px rgba(0,0,0,0.3);*/
}
.topbar button {
    background: var(--primary-color);
    color: #fff;
    border: none;
    padding: 10px 18px;
    border-radius: 25px;
    cursor: pointer;
    font-size: 1rem;
    transition: 0.3s;
}
.topbar button:hover { opacity:0.85; }

/* Course Section */
.course-section { margin-bottom: 35px; }
.course-section h3 { 
    color: var(--primary-color); 
    margin-bottom:15px; 
    font-size:1.4rem; 
    border-bottom: 2px solid var(--primary-color); 
    padding-bottom:5px; 
}

/* Updates Container */
.updates-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 18px;
}

/* Card */
.card {
    background: rgb(15,23,42);
    padding: 22px;
    border-radius: 15px;
    box-shadow: 0 8px 20px rgba(0,0,0,0.1);
    display: flex;
    flex-direction: column;
    transition: 0.3s;
}
.card:hover {
    transform: translateY(-3px);
    box-shadow: 0 12px 28px rgba(0,0,0,0.15);
}
.card h4 { margin: 0 0 8px 0; color: var(--primary-color); font-size: 1.15rem; }
.card small { color: var(--muted); font-size: 0.8rem; }
.card p { margin: 12px 0; flex-grow:1; word-wrap: break-word; }
.card img {
    max-width: 100%;
    height: auto;
    margin-top: 12px;
    border-radius: 10px;
    object-fit: cover;
    display: block;
}
.card a {
    display:inline-block;
    margin-top:12px;
    background: var(--primary-color);
    color: #fff;
    text-decoration: none;
    padding: 8px 14px;
    border-radius: 8px;
    font-size: 0.9rem;
    text-align:center;
    transition:0.2s;
}
.card a:hover { opacity:0.9; }

/* Responsive */
@media(max-width:768px){
    .topbar {
        flex-direction: column;
        gap:12px;
        align-items: flex-start;
    }
    .topbar .logo img { height:55px; }
    .card { padding:16px; }
}
</style>
</head>
<body >

<div class="topbar">
    <div class="logo">
        <img src="../assets/images/Activ8-Hub-logo.png" alt="ActivateHub">
    </div>
    <!--<button onclick="toggleTheme()">Toggle Theme</button>-->
</div>

<?php foreach ($courseList as $course_id => $course_title): ?>
<div class="course-section">
    <h3><?= htmlspecialchars($course_title) ?></h3>
    <?php if (!empty($updatesByCourse[$course_id])): ?>
        <div class="updates-container">
        <?php 
        $counter = 1;
        foreach ($updatesByCourse[$course_id] as $u): ?>
            <div class="card">
                <h4>Update <?= $counter ?>: <?= htmlspecialchars($u['title']) ?></h4>
                <small><?= date("d M Y • h:i A", strtotime($u['created_at'])) ?></small>
                <p><?= nl2br(htmlspecialchars($u['message'])) ?></p>

                <?php if (!empty($u['certificate']) && file_exists("../certificates/".$u['certificate'])): ?>
                    <?php $ext = pathinfo($u['certificate'], PATHINFO_EXTENSION); ?>
                    <?php if(in_array(strtolower($ext), ['jpg','jpeg','png'])): ?>
                        <img src="../certificates/<?= htmlspecialchars($u['certificate']) ?>" alt="Certificate"/>
                    <?php endif; ?>
                    <a href="../certificates/<?= htmlspecialchars($u['certificate']) ?>" download>
                        Download 
                    </a>
                <?php endif; ?>
            </div>
        <?php 
        $counter++;
        endforeach; ?>
        </div>
    <?php else: ?>
        <p style="color: var(--muted); margin-top:10px;">No updates yet for this course.</p>
    <?php endif; ?>
</div>
<?php endforeach; ?>

<script>
function toggleTheme(){
    document.body.classList.toggle('dark');
}
</script>

</body>
</html><br><br>
<?php
include "footer.php"
?>
