<?php
session_start();
include "db.php";

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

/* ================= FETCH USER ================= */
$stmt = $conn->prepare("SELECT * FROM users WHERE id=?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

/* ================= HANDLE IMAGE UPLOAD ================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['profile_image'])) {

    $allowed = ['jpg','jpeg','png','webp'];
    $ext = strtolower(pathinfo($_FILES['profile_image']['name'], PATHINFO_EXTENSION));

    if (!in_array($ext, $allowed)) {
        $error = "Only JPG, PNG or WEBP allowed";
    } elseif ($_FILES['profile_image']['size'] > 2 * 1024 * 1024) {
        $error = "Image must not exceed 2MB";
    } else {

        $dir = "uploads/profile_pics/";
        if (!is_dir($dir)) mkdir($dir, 0755, true);

        $filename = "user_" . $user_id . "_" . time() . "." . $ext;
        $path = $dir . $filename;

        if (move_uploaded_file($_FILES['profile_image']['tmp_name'], $path)) {
            $update = $conn->prepare("UPDATE users SET profile_image=? WHERE id=?");
            $update->bind_param("si", $path, $user_id);
            $update->execute();

            header("Location: profile.php");
            exit;
        } else {
            $error = "Upload failed";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>My Profile</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
/* ===================== COLORS ===================== */
:root{
    --bg: white; /* Default dark background */
    --text:rgb(18,108,201);
    --muted:#94a3b8;
    --primary:#8b5cf6; 
    --blue:#3b82f6; 
    --green:#10b981; 
    --highlight:rgb(245,164,37); /* avatar border & button */
    --red:#ef4444;
}
.light{
    --bg:white;
    --text:#111;
    --muted:#64748b;
    --primary:#8b5cf6;
    --blue:#3b82f6;
    --green:#10b981;
    --highlight:rgb(245,164,37);
    --red:#ef4444;
}

/* ===================== RESET ===================== */
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif;transition:.3s;}
body{background:var(--bg);color:var(--text);min-height:100vh;display:flex;flex-direction:column;}

/* ===================== HEADER ===================== */
header{
    display:flex;justify-content:space-between;align-items:center;
    padding:16px 24px;border-bottom:1px solid rgba(255,255,255,0.1);
}
header img{height:70px}
.toggle-btn{background:var(--highlight);color:#fff;border:none;padding:8px 16px;border-radius:20px;cursor:pointer}

/* ===================== CONTAINER ===================== */
.container{flex:1;display:flex;flex-direction:column;align-items:center;gap:20px;padding:20px}

/* ===================== PROFILE IMAGE ===================== */
.avatar{
    width:140px;height:140px;border-radius:50%;
    border:4px solid rgb(18,108,201);
    object-fit:cover;
}
.upload-box{text-align:center;}
.upload-box input{display:none;}
.upload-box label{
    margin-top:10px;
    display:inline-block;
    background:rgb(18,108,201);
    color:#fff;
    padding:8px 16px;
    border-radius:20px;
    cursor:pointer;
    font-size:14px;
}

/* ===================== PROFILE CARD ===================== */
.profile-card{
    width:100%;max-width:650px;
    padding:18px;border-radius:14px;
    background:rgba(255,255,255,0.05);
    box-shadow:0 4px 15px rgba(0,0,0,0.08);
}
.label{font-size:13px;font-weight:700;text-transform:uppercase;color:var(--muted)}
.value{font-size:18px;font-weight:600;color:var(--text)}

.error{color:var(--red);font-size:14px}

/* ===================== RESPONSIVE ===================== */
@media(max-width:480px){
    .avatar{width:100px;height:100px;}
    .upload-box label{padding:6px 12px;font-size:12px;}
}
</style>
</head>

<body class="">
<header>
    <img src="../assets/images/Activ8-Hub-logo.png">
    <!--<button class="toggle-btn" onclick="toggleTheme()">🌙</button>-->
</header>

<div class="container">

    <!-- PROFILE IMAGE -->
    <div class="upload-box">
        <img class="avatar"
             src="<?php echo $user['profile_image'] ?: 'https://ui-avatars.com/api/?name='.urlencode($user['fullname']); ?>">
        
        <form method="post" enctype="multipart/form-data">
            <label>
                Change Photo
                <input type="file" name="profile_image" accept=".jpg,.jpeg,.png,.webp" onchange="this.form.submit()">
            </label>
        </form>
        <?php if(isset($error)) echo "<div class='error'>$error</div>"; ?>
    </div>

    <div class="profile-card">
        <div class="label">Full Name</div>
        <div class="value"><?php echo htmlspecialchars($user['fullname']); ?></div>
    </div>

    <div class="profile-card">
        <div class="label">Email</div>
        <div class="value"><?php echo htmlspecialchars($user['email']); ?></div>
    </div>

    <!--<div class="profile-card">-->
    <!--    <div class="label">Role</div>-->
    <!--    <div class="value"><?php echo htmlspecialchars($user['role']); ?></div>-->
    <!--</div>-->

    <div class="profile-card">
        <div class="label">Verified</div>
        <div class="value"><?php echo $user['is_verified'] ? 'Yes' : 'No'; ?></div>
    </div>

    <div class="profile-card">
        <div class="label">Created At</div>
        <div class="value"><?php echo htmlspecialchars($user['created_at']); ?></div>
    </div>

</div>

<script>
function toggleTheme(){
    if(document.body.classList.contains('light')){
        document.body.classList.remove('light');
        localStorage.setItem('theme','dark');
    } else {
        document.body.classList.add('light');
        localStorage.setItem('theme','light');
    }
}

// Apply saved theme
if(localStorage.getItem('theme')==='light') document.body.classList.add('light');
</script>

</body>
</html><br><br><br><br>

<?php include "footer.php"; ?>
