<?php
// pdf.php
session_start();
include "../db.php"; // adjust path if needed

if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    exit("Access denied.");
}

if (!isset($_GET['file'])) {
    http_response_code(400);
    exit("Invalid file.");
}

$filename = basename($_GET['file']);
$filepath = __DIR__ . "/../uploads/contents/" . $filename;

if (!file_exists($filepath)) {
    http_response_code(404);
    exit("File not found.");
}

// Serve the PDF
header('Content-Type: application/pdf');
header('Content-Disposition: inline; filename="' . $filename . '"');
readfile($filepath);
exit;
