<?php
session_start();
include "db.php";

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['course'])) {
    die("Invalid Course");
}

$course_id = intval($_GET['course']);
$user_id   = $_SESSION['user_id'];

/* FETCH COURSE */
$stmt = $conn->prepare("SELECT * FROM courses WHERE id = ?");
$stmt->bind_param("i", $course_id);
$stmt->execute();
$course = $stmt->get_result()->fetch_assoc();

if (!$course) {
    die("Course not found");
}

/* FETCH USER EMAIL */
$userStmt = $conn->prepare("SELECT email FROM users WHERE id = ?");
$userStmt->bind_param("i", $user_id);
$userStmt->execute();
$user = $userStmt->get_result()->fetch_assoc();

/* COUNT MODULES */
$modStmt = $conn->prepare("SELECT COUNT(*) AS total FROM modules WHERE course_id = ?");
$modStmt->bind_param("i", $course_id);
$modStmt->execute();
$modules = $modStmt->get_result()->fetch_assoc();
$total_modules = $modules['total'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo htmlspecialchars($course['title']); ?> | Payment</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<script src="https://js.paystack.co/v1/inline.js"></script>

<style>
:root {
    --primary: rgb(245,164,37);
    --bg: rgb(15,23,42);
    --card: rgb(20,30,55);
    --text: #ffffff;
    --muted: #cbd5e1;
}

* {
    box-sizing: border-box;
}

body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background:;
    color: var(--text);
}

/* PAGE WRAPPER */
.page-wrapper {
    padding: 60px 20px 120px;
}

/* CARD */
.course-card {
    max-width: 720px;
    margin: auto;
    background:white ;
    border-radius: 22px;
    overflow: hidden;
    box-shadow: 0 15px 40px rgba(0,0,0,0.4);
    animation: fadeUp 0.7s ease;
}

/* IMAGE */
.course-cover {
    width: 100%;
    height: 320px;
    object-fit: contain;
    background: #000;
}

/* CONTENT */
.course-body {
    padding: 30px;
}

.course-title {
    font-size: 26px;
    font-weight: 700;
    margin-bottom: 10px;
}

.course-meta {
    display: flex;
    flex-wrap: wrap;
    gap: 15px;
    font-size: 14px;
    color: rgb(18,108,201);
    margin-bottom: 20px;
}

.badge {
    background:rgb(18,108,201);
    color: white;
    padding: 6px 12px;
    border-radius: 20px;
    font-weight: 500;
}

/* DESCRIPTION */
.course-description {
    color: var(--muted);
    line-height: 1.7;
    margin-bottom: 15px;
}

/* PRICE */
.course-price {
    font-size: 26px;
    font-weight: 700;
    color: var(--primary);
    text-align: center;
    margin: 25px 0;
}

/* BUTTONS */
.read-more {
    display: inline-block;
    margin-bottom: 15px;
    cursor: pointer;
    color: var(--primary);
    font-weight: 500;
}

.pay-btn {
    width: 100%;
    padding: 16px;
    font-size: 17px;
    border: none;
    border-radius: 14px;
    background: rgb(18,108,201);
    color:white;
    font-weight: 700;
    cursor: pointer;
    transition: 0.3s ease;
}

.pay-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(245,164,37,0.35);
}

/* MODAL */
.modal {
    display: none;
    position: fixed;
    inset: 0;
    background:rgb(18,108,201);;
    z-index: 1000;
}

.modal-content {
    background:rgb(18,108,201);;
    max-width: 600px;
    margin: 10% auto;
    padding: 30px;
    border-radius: 20px;
    animation: scaleIn 0.4s ease;
}

.close {
    float: right;
    font-size: 26px;
    cursor: pointer;
    color: var(--muted);
}

/* ANIMATIONS */
@keyframes fadeUp {
    from { opacity: 0; transform: translateY(25px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes scaleIn {
    from { transform: scale(0.9); opacity: 0; }
    to { transform: scale(1); opacity: 1; }
}

/* RESPONSIVE */
@media(max-width:600px) {
    .course-cover { height: 220px; }
    .course-title { font-size: 22px; }
}
</style>
</head>

<body>

<div class="page-wrapper">

    <div class="course-card">

        <img src="../admin/<?php echo htmlspecialchars($course['cover']); ?>" class="course-cover" style="background-color:white;">

        <div class="course-body">

            <div class="course-title">
                <?php echo htmlspecialchars($course['title']); ?>
            </div>

            <div class="course-meta" >
                <span class="badge" ><?php echo $total_modules; ?> Modules</span>
                <span class="badge">Lifetime Access</span>
            </div>

            <div class="course-description" style="color:rgb(18,108,201);>
                <?php echo substr(strip_tags($course['description']), 0, 160); ?>...
            </div>

            <span class="read-more" onclick="openModal()">Read full description →</span>

            <div class="course-price" style="color:rgb(18,108,201);">
                ₦<?php echo number_format($course['price'], 2); ?>
            </div>

            <button class="pay-btn" onclick="payWithPaystack()" >
                Enroll & Pay Now
            </button>

        </div>
    </div>

</div>

<!-- DESCRIPTION MODAL -->
<div id="descriptionModal" class="modal">
  <div class="modal-content">
    <span class="close" onclick="closeModal()">&times;</span>
    <h2><?php echo htmlspecialchars($course['title']); ?></h2>
    <p><?php echo nl2br($course['description']); ?></p>
  </div>
</div>

<script>
function openModal(){
    document.getElementById('descriptionModal').style.display='block';
}
function closeModal(){
    document.getElementById('descriptionModal').style.display='none';
}

function payWithPaystack(){
    let handler = PaystackPop.setup({
        key: "pk_live_b713fa6af790127ad1901d7f2aea755c0c2895e8",
        email: "<?php echo $user['email']; ?>",
        amount: <?php echo $course['price']; ?> * 100,
        currency: "NGN",
        callback: function(response){
            window.location =
              "verify_payment.php?reference=" + response.reference +
              "&course=<?php echo $course_id; ?>";
        },
        onClose: function(){
            alert("Payment cancelled");
        }
    });
    handler.openIframe();
}
</script>

<?php include "footer.php"; ?>

</body>
</html>
