<?php
session_start();
include "db.php";

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch payments
$stmt = $conn->prepare("
    SELECT p.*, c.title 
    FROM user_payments p
    LEFT JOIN courses c ON p.course_id = c.id
    WHERE p.user_id = ?
    ORDER BY p.created_at DESC
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

// ✅ FIX: cache rows first, then calculate stats
$rows = [];
$totalPaid = 0;
$totalCourses = 0;

while ($row = $result->fetch_assoc()) {
    $rows[] = $row;

    if ($row['status'] === 'success') {
        $totalPaid += (float) $row['amount'];
        $totalCourses++;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>My Payments</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
:root{
    --primary:#5d5dff;
    --bg:white;
    --glass:rgba(255,255,255,0.08);
    --text:#ffffff;
    --muted:#b6b6d6;
}
body.light{
    --bg:#f4f6ff;
    --glass:rgba(255,255,255,0.9);
    --text:#1a1a2e;
    --muted:#555;
}
*{box-sizing:border-box}
body{
    margin:0;
    font-family:'Poppins',sans-serif;
    background:white;
    color:var(--text);
    min-height:100vh;
    transition:.3s;
}
body.light{
    background:;
}

/* Header */
.header{
    position:sticky;
    top:0;
    z-index:10;
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:16px 22px;
    backdrop-filter: blur(15px);
    background:var(--glass);
    border-bottom:1px solid rgba(255,255,255,.1);
}
.header h2{
    margin:0;
    font-size:20px;
    font-weight:600;
}
.toggle{
    background:rgb(245,164,37);
    padding:8px 14px;
    border-radius:20px;
    cursor:pointer;
    font-size:13px;
    color:white;
}

/* Container */
.container{
    max-width:1200px;
    margin:30px auto;
    padding:0 16px;
}

/* Stats */
.stats{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
    gap:20px;
    margin-bottom:35px;
}
.stat-card{
    background:var(--glass);
    backdrop-filter:blur(15px);
    padding:22px;
    border-radius:18px;
    box-shadow:0 10px 30px rgba(0,0,0,.25);
}
.stat-card h3{
    margin:0;
    font-size:14px;
    color:var(--muted);
}
.stat-card p{
    margin-top:10px;
    font-size:26px;
    font-weight:700;
}

/* Payments */
.grid{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(300px,1fr));
    gap:24px;
}

.card{
    background:rgb(18,108,201);
    backdrop-filter:blur(18px);
    padding:22px;
    border-radius:20px;
    box-shadow:0 15px 35px rgba(0,0,0,.3);
    transition:.3s;
}
.card:hover{
    transform:translateY(-6px);
}

.card h4{
    margin:0 0 12px;
    font-size:18px;
    font-weight:600;
}

.meta{
    font-size:14px;
    margin-bottom:6px;
    color:var(--muted);
}
.meta span{
    color:var(--text);
    font-weight:500;
}

.status{
    margin-top:14px;
    display:inline-block;
    padding:6px 14px;
    border-radius:30px;
    font-size:12px;
    font-weight:500;
}
.success{
    background:rgba(31,157,85,.2);
    color:#1f9d55;
}
.failed{
    background:rgba(229,62,62,.2);
    color:#e53e3e;
}

/* Empty */
.empty{
    text-align:center;
    opacity:.7;
    margin-top:80px;
}

/* Mobile */
@media(max-width:600px){
    .header h2{font-size:18px}
    .stat-card p{font-size:22px}
}
</style>
</head>

<body>

<div class="header" style="background-color:white;">
    <div class="logo">
    <img src="../assets/images/Activ8-Hub-logo.png" alt="ActivateHub" style="height:77px;">
</div>

    <!--<div class="toggle" onclick="toggleTheme()">🌗</div>-->
</div>

<div class="container">

<!--<div class="stats">-->
<!--    <div class="stat-card">-->
<!--        <h3>Total Spent</h3>-->
<!--        <p>₦<?php echo number_format($totalPaid,2); ?></p>-->
<!--    </div>-->
<!--    <div class="stat-card">-->
<!--        <h3>Courses Purchased</h3>-->
<!--        <p><?php echo $totalCourses; ?></p>-->
<!--    </div>-->
<!--</div>-->

<?php if (empty($rows)): ?>
    <div class="empty">
        <h3>No payments yet</h3>
        <p>Your payment history will appear here.</p>
    </div>
<?php else: ?>
<div class="grid">
<?php foreach ($rows as $row): ?>
    <div class="card">
        <h4><?php echo htmlspecialchars($row['title'] ?? 'Course'); ?></h4>

        <div class="meta">
            Amount:
            <span>₦<?php echo number_format($row['amount'],2); ?></span>
        </div>
        <div class="meta">
            Reference:
            <span><?php echo htmlspecialchars($row['reference']); ?></span>
        </div>
        <div class="meta">
            Date:
            <span><?php echo date("d M Y · h:i A", strtotime($row['created_at'])); ?></span>
        </div>

        <span class="status <?php echo $row['status']==='success'?'success':'failed'; ?>">
            <?php echo ucfirst($row['status']); ?>
        </span>
    </div>
<?php endforeach; ?>
</div>
<?php endif; ?>

</div>

<script>
function toggleTheme(){
    document.body.classList.toggle('light');
    localStorage.setItem(
        'theme',
        document.body.classList.contains('light') ? 'light' : 'dark'
    );
}
if(localStorage.getItem('theme') === 'light'){
    document.body.classList.add('light');
}
</script>

</body>
</html><br><br><br>
<?php

include "footer.php";
?>
