<?php
session_start();
include "db.php";

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

/*
|--------------------------------------------------------------------------
| FETCH USER COURSES WITH REAL-TIME PROGRESS
|--------------------------------------------------------------------------
| Progress = (completed modules / total modules) * 100
| A module is completed when user_module_progress.completed = 100
*/
$stmt = $conn->prepare("
    SELECT 
        c.id,
        c.title,
        c.cover,
        c.tutor,
        c.price,

        COUNT(DISTINCT m.id) AS total_modules,

        COUNT(DISTINCT CASE 
            WHEN ump.completed = 100 THEN ump.module_id
        END) AS completed_modules,

        ROUND(
            (COUNT(DISTINCT CASE 
                WHEN ump.completed = 100 THEN ump.module_id
            END) / NULLIF(COUNT(DISTINCT m.id), 0)) * 100
        ) AS progress

    FROM user_courses uc
    JOIN courses c ON uc.course_id = c.id

    LEFT JOIN modules m 
        ON m.course_id = c.id

    LEFT JOIN user_module_progress ump
        ON ump.user_id = uc.user_id
        AND ump.course_id = c.id
        AND ump.module_id = m.id

    WHERE uc.user_id = ?
    GROUP BY c.id
    ORDER BY uc.purchased_at DESC
");

$stmt->bind_param("i", $user_id);
$stmt->execute();
$purchased_courses = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>My Courses</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
:root{
    --bg:white;
    --card:white;
    --text:rgb(15,23,42);
    --muted:#cbd5f5;
    --accent:rgb(18,108,201);
}

.light{
    --bg:#f8fafc;
    --card:#ffffff;
    --text:#0f172a;
    --muted:#475569;
}

*{ box-sizing:border-box; }

body{
    margin:0;
    font-family:'Poppins',sans-serif;
    background:var(--bg);
    color:var(--text);
    transition:0.3s ease;
}

/* HEADER */
.top-bar{
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:15px 20px;
    max-width:1200px;
    margin:auto;
}

/* MAIN */
.container{
    max-width:1200px;
    margin:20px auto 60px;
    padding:0 20px;
}

.page-title{
    text-align:center;
    font-size:32px;
    margin-bottom:30px;
    color:var(--accent);
}

/* GRID */
.courses-grid{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(280px,1fr));
    gap:25px;
}

/* CARD */
.course-card{
    background:var(--card);
    border-radius:20px;
    overflow:hidden;
    display:flex;
    flex-direction:column;
    box-shadow:0 10px 30px rgba(0,0,0,0.25);
    transition:0.3s ease;
}

.course-card:hover{
    transform:translateY(-8px);
}

/* COVER */
.course-cover{
    width:100%;
    height:200px;
    background:;
    object-fit:contain;
}

/* BODY */
.course-body{
    padding:18px;
    display:flex;
    flex-direction:column;
    flex-grow:1;
}

.course-title{
    font-size:20px;
    font-weight:600;
}

.course-tutor{
    font-size:14px;
    color:var(--muted);
    margin-bottom:15px;
}

/* PROGRESS */
.progress-wrap{
    margin-bottom:12px;
}

.progress-bar-bg{
    height:8px;
    width:100%;
    background:#334155;
    border-radius:5px;
}

.progress-bar-fill{
    height:8px;
    background:#10b981;
    border-radius:5px;
    transition:width 0.6s ease;
}

.progress-text{
    font-size:13px;
    margin-top:6px;
}

/* BUTTON */
.btn{
    margin-top:auto;
    text-align:center;
    padding:12px;
    border-radius:10px;
    background:var(--accent);
    color:#000;
    font-weight:600;
    text-decoration:none;
}

.btn:hover{ opacity:0.9; }

/* MOBILE */
@media(max-width:480px){
    .page-title{font-size:26px;}
    .course-cover{height:180px;}
}
</style>
</head>

<body>

<div class="top-bar">
    <img src="../assets/images/Activ8-Hub-logo.png"
         style="height:70px"
         onerror="this.style.display='none'">
</div>

<div class="container">
    <h1 class="page-title">My Courses</h1>

<?php if ($purchased_courses->num_rows > 0): ?>
    <div class="courses-grid">
        <?php while ($course = $purchased_courses->fetch_assoc()): ?>
        <?php $progress = (int)($course['progress'] ?? 0); ?>

        <div class="course-card">
            <img src="../admin/<?php echo htmlspecialchars($course['cover']); ?>"
                 alt="<?php echo htmlspecialchars($course['title']); ?>"
                 class="course-cover">

            <div class="course-body">
                <div>
                    <div class="course-title"><?php echo htmlspecialchars($course['title']); ?></div>
                    <div class="course-tutor" style="color:rgb(18,108,201);">Tutor: <?php echo htmlspecialchars($course['tutor']); ?></div>
                </div>

                <div class="progress-wrap">
                    <div class="progress-bar-bg">
                        <div class="progress-bar-fill"
                             style="width:<?php echo $progress; ?>%">
                        </div>
                    </div>
                    <div class="progress-text">
                        <?php echo $progress; ?>% completed
                        (<?php echo (int)$course['completed_modules']; ?>/<?php echo (int)$course['total_modules']; ?> modules)
                    </div>
                </div>

                <a href="study.php?course=<?php echo (int)$course['id']; ?>" class="btn">
                    Continue Learning →
                </a>
            </div>
        </div>
        <?php endwhile; ?>
    </div>
<?php else: ?>
    <p style="text-align:center;color:var(--accent);font-size:18px;">
        You have not purchased any courses yet.
    </p>
<?php endif; ?>
</div>



</body>
</html><br><br>
<?php include "footer.php"; ?>
