<?php
session_start();
include "../user/db.php";

if (!isset($_SESSION['user_id'])) {
    $_SESSION['redirect_to'] = $_SERVER['REQUEST_URI'];
    echo "<script>alert('Please login to access your dashboard.'); window.location='login.php';</script>";
    exit;
}

// Fetch logged-in user info
$user_id = $_SESSION['user_id'];
$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

// Prepare initials from fullname
$names = explode(' ', $user['fullname']);
$initials = strtoupper(substr($names[0],0,1) . (isset($names[1]) ? substr($names[1],0,1) : ''));

// Sample progress (replace with actual course progress if available)
$progress_percentage = 100; // Example
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Dashboard</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Oswald:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* Animate progress bar width */
        .progress-fill {
            width: 0%;
            height: 100%;
            background: linear-gradient(90deg, rgba(135,206,235,1), rgba(255,215,0,1), rgba(0,0,128,1));
            border-radius: 20px;
            transition: width 1.2s ease-in-out;
        }
    </style>
</head>
<body style="background-color:white;">
<div class="dashboard-container">

    <!-- Header -->
    <header class="header">
        <div class="logo">
            <img src="../assets/images/Activ8-Hub-logo.png" alt="ActivateHub" style="height:77px;">
        </div>

        <div class="user-info">
            <img src="<?php echo $user['profile_image'] ?: 'https://ui-avatars.com/api/?name='.urlencode($user['fullname']); ?>" 
                 alt="Profile Picture" 
                 style="width:50px; height:50px; border-radius:50%; border:2px solid rgb(7,75,193); object-fit:cover;">

        </div>
    </header>

    <!-- Welcome Section -->
    <section class="welcome-section" style="
        padding: 20px 16px;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 22px;
        width: 100%;
        max-width: 1100px;
        margin: 0 auto;
        box-sizing: border-box;
    ">

        <!-- Profile + Name + Progress Wrapper -->
        <div style="display:flex; align-items:center; gap:20px; flex-wrap:wrap; width:100%; max-width:1100px; margin:0 auto;">

            <!-- Profile Image -->
           
            <!-- Name + Progress Card -->
            <div style="flex:1; display:flex; flex-direction:column; gap:12px;">

                <!-- Welcome Message -->
                <div class="welcome-message" style="width:100%; text-align:left;">
                    <h1 style="margin:0; font-size:clamp(20px,4vw,28px); font-weight:600; color: rgb(18,108,201); font-family:'Oswald',sans-serif;">
                        Hi, <?= htmlspecialchars($user['fullname']) ?>
                    </h1>
                </div>

                <!-- Progress Card -->
                <div class="progress-card" style="
                    background: linear-gradient(135deg, rgba(135,206,235,0.85) 0%, rgb(8,95,214) 50%, rgba(0,0,128,0.85) 100%);
                    border-radius: 18px;
                    padding: 22px;
                    color: #ffffff;
                    position: relative;
                    overflow: hidden;
                    width: 100%;
                    max-width: 520px;
                    margin: 0 auto;
                    box-shadow: 0 15px 30px rgba(0,0,0,0.25);
                    box-sizing: border-box;
                ">

                    <!-- Pattern Overlay -->
                    <div style="
                        position: absolute;
                        inset: 0;
                        background: repeating-linear-gradient(
                            45deg,
                            rgba(255,255,255,0.25),
                            rgba(255,255,255,0.25) 10px,
                            transparent 10px,
                            transparent 20px
                        );
                        border-radius: 18px;
                        pointer-events: none;
                    "></div>

                    <!-- Header -->
                    <div style="position: relative; z-index:1; display:flex; justify-content:space-between; align-items:center;">
                        <img src="../assets/images/Activ8-Hub-logo.png" alt="ActivateHub" style="height:50px;">
                        <i class="fas fa-user-graduate" style="font-size:18px;"></i>
                    </div>

                    <!-- Progress Content -->
                    <div style="position: relative; z-index:1; margin-top:22px;">
                        <p style="margin:0; font-size:12px; letter-spacing:0.6px; opacity:0.9;">REGISTRATION PROGRESS</p>
                        <p style="font-size:clamp(20px,4vw,26px); font-weight:700; margin:6px 0 14px;"><?= $progress_percentage ?>% Completion</p>

                        <div style="background: rgba(255,255,255,0.3); border-radius:20px; height:14px; overflow:hidden;">
                            <div class="progress-fill"></div>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div style="position: relative; z-index:1; margin-top:16px; font-size:13px; opacity:0.95;">
                        <p style="margin:0;">Member since: <?= date("F j, Y", strtotime($user['created_at'])) ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Action Icons -->
    <section class="action-icons">
        <a href="course.php" class="icon-item-link" style="text-decoration:none; color:inherit;">
            <div class="icon-item">
                <div class="icon-circle enroll-course" style="background-color:rgb(18,108,201);"><i class="fas fa-plus"></i></div>
                <p style="color:rgb(15,23,42);">Enroll Course</p>
            </div>
        </a>
        <a href="my_courses.php" class="icon-item-link" style="text-decoration:none; color:inherit;">
            <div class="icon-item">
                <div class="icon-circle my-courses"><i class="fas fa-book-open"></i></div>
                <p style="color:rgb(15,23,42);">My Courses</p>
            </div>
        </a>
        <a href="message.php" class="icon-item-link" style="text-decoration:none; color:inherit;">
            <div class="icon-item">
                <div class="icon-circle messages" style="background-color:rgb(15,23,42)"><i class="fas fa-paper-plane"></i></div>
                <p style="color:rgb(15,23,42);">Submit</p>
            </div>
        </a>
        <a href="updates.php" class="icon-item-link" style="text-decoration:none; color:inherit;">
            <div class="icon-item">
                <div class="icon-circle schedule"><i class="fas fa-bell"></i></div>
                <p style="color:rgb(15,23,42);">Updates</p>
            </div>
        </a>
    </section>

    <!-- Promo Banner -->
   <section class="promo-banner" style="
    position: relative;
    width: 100%;
    height: 180px; /* landscape height */
    overflow: hidden;
    border-radius: 12px;
    max-width: 1000px;
    margin: 0 auto;
    display: flex;
    align-items: center;
    justify-content: center;
">

    <!-- Banner Images -->
    <img src="../assets/images/c1.png" class="banner-image" style="
        position:absolute;
        top:0;
        left:0;
        width:100%;
        height:100%;
        object-fit:cover;
        animation: fade 12s infinite;
    ">
    <img src="../assets/images/c2.png" class="banner-image" style="
        position:absolute;
        top:0;
        left:0;
        width:100%;
        height:100%;
        object-fit:cover;
        animation: fade 12s infinite 4s;
    ">
    <img src="../assets/images/c3.png" class="banner-image" style="
        position:absolute;
        top:0;
        left:0;
        width:100%;
        height:100%;
        object-fit:cover;
        animation: fade 12s infinite 8s;
    ">

    <!-- Dark Overlay -->
    <div style="
        position: absolute;
        inset: 0;
        background: rgba(0,0,0,0.45); /* darkens images */
        z-index: 1;
    "></div>

    <!-- Overlay Text -->
    <div style="
        position: absolute;
        bottom: 15px;
        left: 20px;
        color: #fff;
        font-size: 18px;
        font-weight: bold;
        z-index: 2;
        text-shadow: 1px 1px 4px rgba(0,0,0,0.6);
    ">
        Unlock your potential with <strong>expert-led courses</strong>.
    </div>
</section>
<br><br><br><br>

<style>
@keyframes fade {
    0%   { opacity: 0; }
    8%   { opacity: 1; }
    33%  { opacity: 1; }
    41%  { opacity: 0; }
    100% { opacity: 0; }
}
</style>

</div>
<script>
const toggle = document.getElementById('themeToggle');
const icon = document.getElementById('themeIcon');

if (localStorage.getItem('theme') === 'light') {
    document.body.classList.add('light-theme');
    icon?.classList.replace('fa-moon', 'fa-sun');
}

// Animate progress bar on page load
document.addEventListener("DOMContentLoaded", function() {
    const fill = document.querySelector(".progress-fill");
    fill.style.width = "<?= $progress_percentage ?>%";
});

toggle?.addEventListener("click", () => {
    document.body.classList.toggle('light-theme');
    const isLight = document.body.classList.contains('light-theme');

    icon.classList.toggle('fa-sun', isLight);
    icon.classList.toggle('fa-moon', !isLight);

    localStorage.setItem('theme', isLight ? 'light' : 'dark');
});
</script>

</body>
</html>

<?php
include "footer.php";
?>
