<?php
session_start();
include "db.php";

if (!isset($_SESSION['user_id'])) {
    $_SESSION['redirect_to'] = $_SERVER['REQUEST_URI'];
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

/* PAGINATION */
$total = $conn->query("SELECT COUNT(*) AS total FROM courses")->fetch_assoc()['total'];
$per_page = 6;
$total_pages = ceil($total / $per_page);
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$start = ($page - 1) * $per_page;

$courses = $conn->query("SELECT * FROM courses ORDER BY created_at DESC LIMIT $start,$per_page");

/* PURCHASED */
$stmt = $conn->prepare("SELECT course_id, progress FROM user_courses WHERE user_id=?");
$stmt->bind_param("i",$user_id);
$stmt->execute();
$res = $stmt->get_result();
$owned=[];
while($r=$res->fetch_assoc()){
    $owned[$r['course_id']]=$r['progress'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Courses</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
:root{
  --accent:rgb(18,108,201);
  --bg:white;
  --card:white;
  --text:rgb(15,23,42);
  --muted:rgb(18,108,201);
}

*{box-sizing:border-box}
body{
  margin:0;
  font-family:Poppins,sans-serif;
  background:var(--bg);
  color:var(--text);
}

.page{
  max-width:1200px;
  margin:auto;
  padding:40px 20px 120px;
}

h1{
  text-align:center;
  margin-bottom:30px;
  color:var(--accent);
}

.search{
  width:100%;
  padding:14px;
  border-radius:12px;
  border:none;
  margin-bottom:30px;
  font-size:16px;
}

/* GRID */
.grid{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(260px,1fr));
  gap:30px;
}

/* FLIP CARD */
.card{
  perspective:1200px;
}

.inner{
  position:relative;
  width:100%;
  height:380px;
  transition:transform .8s cubic-bezier(.4,.2,.2,1);
  transform-style:preserve-3d;
}

.card:hover .inner{
  transform:rotateY(180deg);
}

.face{
  position:absolute;
  inset:0;
  backface-visibility:hidden;
  border-radius:18px;
  overflow:hidden;
  background:var(--card);
  box-shadow:0 20px 40px rgba(0,0,0,.35);
}

/* FRONT */
.front{
  display:flex;
  flex-direction:column;
  justify-content:flex-end;
}
.front img{
  position:absolute;
  inset:0;
  width:100%;
  height:100%;
  object-fit:contain;
  background:white;
}
.front .title{
  position:relative;
  padding:20px;
  background:white;
  font-size:20px;
  font-weight:600;
}

/* BACK */
.back{
  transform:rotateY(180deg);
  padding:20px;
  display:flex;
  flex-direction:column;
}

.tutor{font-size:14px;color:var(--muted)}
.price{font-size:20px;font-weight:700;color:var(--accent);margin:10px 0}

.desc{
  font-size:14px;
  color:#e5e7eb;
  line-height:1.5;
  display:-webkit-box;
  -webkit-line-clamp:4;
  -webkit-box-orient:vertical;
  overflow:hidden;
}

.actions{
  margin-top:auto;
  display:flex;
  flex-direction:column;
  gap:10px;
}

.btn{
  padding:12px;
  text-align:center;
  border-radius:12px;
  font-weight:600;
  text-decoration:none;
  transition:.3s;
}
.buy{background:var(--accent);color:#000}
.continue{background:#10b981;color:#000}
.more{background:#334155;color:#fff}

/* PROGRESS */
.progress{
  height:8px;
  background:#334155;
  border-radius:6px;
  overflow:hidden;
}
.fill{
  height:8px;
  background:#10b981;
}

/* PAGINATION */
.pagination{
  text-align:center;
  margin-top:50px;
}
.pagination a{
  margin:6px;
  padding:10px 14px;
  border-radius:8px;
  background:var(--accent);
  color:#000;
  text-decoration:none;
}
.active{}

/* MODAL */
.modal{
  display:none;
  position:fixed;
  inset:0;
  background:rgba(0,0,0,.7);
  z-index:50;
}
.modal-box{
  max-width:520px;
  margin:10% auto;
  background:#020617;
  padding:25px;
  border-radius:16px;
}
.close{
  float:right;
  cursor:pointer;
  font-size:22px;
}

@media(max-width:640px){
  .inner{height:340px}
}
</style>
</head>

<body>

<div class="page">

<h1>Available Courses</h1>

<input class="search" id="searchBar" placeholder="Search courses...">

<div class="grid" id="courseList">

<?php while($c=$courses->fetch_assoc()): ?>
<div class="card">
  <div class="inner">

    <!-- FRONT -->
    <div class="face front" style="background-color:white;">
      <img src="../admin/<?= $c['cover'] ?>">
      <div class="title"><?= htmlspecialchars($c['title']) ?></div>
    </div>

    <!-- BACK -->
    <div class="face back">
      <h3><?= htmlspecialchars($c['title']) ?></h3>
      <div class="tutor">Tutor: <?= htmlspecialchars($c['tutor']) ?></div>
      <div class="price">₦<?= number_format($c['price'],2) ?></div>

      <p class="desc" style= "color:rgb(15,23,42);"><?= htmlspecialchars($c['description']) ?></p>

      <div class="actions">
        <button class="btn more" onclick="openModal(`<?= htmlspecialchars($c['description']) ?>`)">Read more</button>

        <?php if(isset($owned[$c['id']])): ?>
          <!--<div class="progress">-->
          <!--  <div class="fill" style="width:<?= $owned[$c['id']] ?>%"></div>-->
          <!--</div>-->
          <a class="btn continue" href="study.php?course=<?= $c['id'] ?>" style="background-color:rgb(18,108,201);">
            Continue 
          </a>
        <?php else: ?>
          <a class="btn buy" href="pay.php?course=<?= $c['id'] ?>">Buy Course</a>
        <?php endif; ?>
      </div>
    </div>

  </div>
</div>
<?php endwhile; ?>

</div>

<!-- PAGINATION -->
<div class="pagination">
<?php for($i=1;$i<=$total_pages;$i++): ?>
<a class="<?= $i==$page?'active':'' ?>" href="?page=<?= $i ?>"><?= $i ?></a>
<?php endfor; ?>
</div>

</div>

<!-- MODAL -->
<div class="modal" id="modal" style="background-color:white;">
  <div class="modal-box" style="background-color:white;">
    <span class="close" onclick="closeModal()">&times;</span>
    <h3>Description</h3>
    <p id="modalText"></p>
  </div>
</div>

<script>
document.getElementById("searchBar").addEventListener("keyup",e=>{
  let v=e.target.value.toLowerCase();
  document.querySelectorAll(".card").forEach(c=>{
    c.style.display=c.innerText.toLowerCase().includes(v)?"block":"none";
  });
});

function openModal(t){
  modalText.innerText=t;
  modal.style.display="block";
}
function closeModal(){
  modal.style.display="none";
}
</script>

</body>
</html>

<?php include "footer.php"; ?>
