<?php
session_start();
include "db.php";

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch user activities
$stmt = $conn->prepare("
    SELECT * 
    FROM study_activity 
    WHERE user_id=? 
    ORDER BY created_at DESC
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$activities = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>My Study Activity</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
:root{
    --bg:white; --text:#111; --muted:#64748b;
    --purple:#8b5cf6; --green:#10b981; --orange:#f59e0b; --blue:#3b82f6; --gray:#6b7280;
}
.dark{
    --bg:white; --text:#f8fafc; --muted:#94a3b8;
    --purple:#a78bfa; --green:#22c55e; --orange:#fbbf24; --blue:#60a5fa; --gray:#9ca3af;
}
*{box-sizing:border-box;}
body{
    margin:0;font-family:'Poppins',sans-serif;
    background:var(--bg);color:var(--text);
    display:flex;flex-direction:column;min-height:100vh;
    transition:.3s;
}

/* HEADER */
header{
    display:flex;align-items:center;justify-content:space-between;
    padding:16px 24px;background:white;color:#fff;
    position:sticky;top:0;z-index:1000;
    box-shadow:0 4px 12px rgba(0,0,0,0.2);
}
header img.logo{height:40px;}
header h1{margin:0;font-size:20px;font-weight:600;}
.toggle-btn{
    border:none;border-radius:18px;padding:8px 16px;
    background:#fff;color:var(--blue);cursor:pointer;font-weight:600;
    transition:.3s;
}
.toggle-btn:hover{background:rgba(255,255,255,.9);}

/* MAIN CONTENT */
.container{
    flex:1;
    max-width:1100px;
    margin:40px auto 20px;
    padding:0 16px;
    display:flex;
    flex-direction:column;
    gap:12px;
}

/* ACTIVITY ROW */
.activity-row{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(140px,1fr));
    align-items:center;
    gap:12px;
    padding:14px 16px;
    border-radius:12px;
    background:rgba(255,255,255,.85);
    transition:.3s;
}
.dark .activity-row{background:rgba(30,41,59,.85);}
.activity-row:hover{transform:translateY(-3px);background:rgba(99,102,241,.1);}
.activity-row div{
    display:flex;flex-direction:column;
    font-size:14px;
}
.activity-row div span.label{
    font-weight:500;margin-bottom:2px;font-size:12px;
    text-transform:uppercase;
    letter-spacing:.5px;
}

/* COLOR CODING */
.course-name span.label{color:var(--purple);}
.time-spent span.label{color:var(--green);}
.total-today span.label{color:var(--orange);}
.progress-field span.label{color:var(--blue);}
.recorded span.label{color:var(--gray);}

/* INLINE PROGRESS BAR */
.progress-bar-bg{
    width:100%; height:8px; background:#e5e7eb; border-radius:8px; margin-top:4px;
}
.progress-bar-fill{
    height:8px; border-radius:8px; transition:width .5s ease;
    background:var(--blue);
}

/* FOOTER */

/* RESPONSIVE */
@media(max-width:768px){.activity-row{grid-template-columns:repeat(2,1fr);}}
</style>
</head>
<body>

<header>
    <img src="../assets/images/Activ8-Hub-logo.png" class="logo" alt="Logo" style="height:90px;">
    <!--<h1>Activities</h1>-->
    <!--<button class="toggle-btn" onclick="toggleTheme()">🌗 </button>-->
</header>

<div class="container">
<?php if($activities->num_rows>0): ?>
<?php while($act=$activities->fetch_assoc()): ?>
<div class="activity-row">
    <div class="course-name">
        <span class="label">Course:</span>
        <span><?php echo htmlspecialchars($act['course_name'] ?? 'Unknown'); ?></span>
    </div>
    <div class="time-spent">
        <span class="label">Time Spent:</span>
        <span><?php echo gmdate("H:i:s",$act['time_spent']); ?></span>
    </div>
    <div class="total-today">
        <span class="label">Total Today:</span>
        <span><?php echo $act['Total_seconds_spent_today'] ?? 0; ?> sec</span>
    </div>
    <div class="progress-field">
        <span class="label">Progress:</span>
        <span><?php echo $act['progress']; ?>%</span>
        <div class="progress-bar-bg">
            <div class="progress-bar-fill" style="width:<?php echo $act['progress']; ?>%"></div>
        </div>
    </div>
    <div class="recorded">
        <span class="label">Recorded:</span>
        <span><?php echo $act['created_at']; ?></span>
    </div>
</div>
<?php endwhile; ?>
<?php else: ?>
<p style="text-align:center;color:var(--blue);font-size:16px;">No activity recorded yet. Start studying!</p>
<?php endif; ?>
</div>


<script>
// Theme toggle
function toggleTheme(){
    document.body.classList.toggle('dark');
    localStorage.setItem('theme', document.body.classList.contains('dark')?'dark':'light');
}
if(localStorage.getItem('theme')==='dark') document.body.classList.add('dark');
</script>

</body>
</html><br><br>
<?php

include "footer.php";
?>

