<?php
session_start();
include "db.php";

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch user certificates
$stmt = $conn->prepare("
    SELECT c.id, c.image_path, cr.title AS course_title, c.issued_at
    FROM certificates c
    JOIN courses cr ON c.course_id = cr.id
    WHERE c.user_id = ?
    ORDER BY c.issued_at DESC
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$certificates = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>My Certificates</title>
<link rel="stylesheet" href="style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Oswald:wght@300;400;500;600;700&family=Montserrat&display=swap" rel="stylesheet">
<style>
body { background-color:white; color: #fff; font-family: 'Montserrat', sans-serif; margin:0; padding:0; }
.dashboard-container { max-width: 1200px; margin: 0 auto; padding: 20px; }
.header { display:flex; align-items:center; gap:20px; margin-bottom:20px; }
.header img { height:60px; }
.header h1 { color: rgb(18,108,201); font-family: 'Oswald', sans-serif; margin:0; }
.cert-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin-top: 20px; }
.cert-card { background:; border-radius: 12px; overflow: hidden; padding: 15px; display: flex; flex-direction: column; align-items: center; box-shadow: 0 6px 12px rgba(0,0,0,0.3); }
.cert-card img { width: 100%; border-radius: 8px; margin-bottom: 12px; }
.cert-card h2 { font-size: 18px; margin: 6px 0; color: white; text-align: center; }
.cert-card p { font-size: 14px; margin: 4px 0; opacity: 0.9; text-align: center; }
.download-btn { padding: 10px 18px; background: rgb(18,108,201); color: #0f172a; border:none; border-radius: 8px; cursor:pointer; font-weight:600; text-decoration:none; transition: 0.2s; }
.download-btn:hover { background: #e09f2d; }
</style>
</head>
<body>
<div class="dashboard-container">

    <div class="header">
        <img src="../assets/images/Activ8-Hub-logo.png" alt="ActivateHub Logo">
        
    </div>
    <h1 class="header" style=" color: rgb(18,108,201); font-family: 'Oswald', sans-serif; margin:0;">My Certificates</h1>

    <div class="cert-grid">
        <?php if($certificates->num_rows > 0): ?>
            <?php while($cert = $certificates->fetch_assoc()): ?>
                <div class="cert-card">
                    <img src="<?= htmlspecialchars($cert['image_path']) ?>" alt="Certificate for <?= htmlspecialchars($cert['course_title']) ?>">
                    <h2><?= htmlspecialchars($cert['course_title']) ?></h2>
                    <p>Issued: <?= date("F j, Y", strtotime($cert['issued_at'])) ?></p>
                    <a href="<?= htmlspecialchars($cert['image_path']) ?>" download class="download-btn">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <p style="grid-column: 1/-1; text-align:center; opacity:0.8;">You haven't earned any certificates yet.</p>
        <?php endif; ?>
    </div><br><br><br><br><br><br><br>

</div>
<?php
include "footer.php";
?>
</body>
</html>


