<?php
session_start();
require 'user/db.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    // Check if email exists
    $stmt = $conn->prepare("SELECT id, password, is_verified, role, fullname FROM users WHERE email=?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();
    $stmt->bind_result($id, $hashed_password, $is_verified, $role, $name);
    $stmt->fetch();

    if ($stmt->num_rows === 0) {
        $error = "Email not registered.";
    } else if (!password_verify($password, $hashed_password)) {
        $error = "Incorrect password.";
    } else if ($is_verified == 0) {
        $error = "Email not verified. Check your inbox.";
    } else {
        // ✅ Correct session setup after verifying user
        $_SESSION['user_id'] = $id;
        $_SESSION['email'] = $email;  // This will now work in pay.php
        $_SESSION['name'] = $name;
        $_SESSION['role'] = $role;

        $success = "Login successful!";

        // Decide dashboard based on role
        if ($role === 'admin') {
            $_SESSION['dashboard'] = 'admin/dashboard.php';
        } else {
            $_SESSION['dashboard'] = 'user/dashboard.php';
        }
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Login</title>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
body { font-family:'Poppins',sans-serif; background: rgb(21,97,179); color:white; display:flex; justify-content:center; align-items:center; min-height:100vh; }
.login-container { background: rgba(255,255,255,0.05); padding: 40px 30px; border-radius: 15px; width:100%; max-width:400px; box-shadow: 0 8px 20px rgba(0,0,0,0.3); transition: transform 0.3s ease, box-shadow 0.3s ease; }
.login-container h2 { text-align:center; margin-bottom:25px; color: white; }
.login-container form { display:flex; flex-direction:column; gap:20px; }
.login-container input { padding:12px 15px; border:none; border-radius:10px; background: white; color:black; font-size:16px; }
.login-container button { padding:12px; border:none; border-radius:10px; background: white; color: rgb(23,35,58); font-weight:bold; cursor:pointer; }
.login-container button:hover { background: rgb(21,97,179); }
.login-container .register-link { text-align:center; margin-top:10px; font-size:14px; opacity:0.8; }
.login-container .register-link a { color: rgb(245,164,37); text-decoration:none; }
/* Preloader */
#preloader { display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(23,35,58,0.8); z-index:9999; justify-content:center; align-items:center; }
#preloader div { border: 4px solid #f3f3f3; border-top: 4px solid rgb(245,164,37); border-radius: 50%; width:40px; height:40px; animation: spin 1s linear infinite; }
@keyframes spin { 0% { transform: rotate(0deg);} 100% { transform: rotate(360deg);} }
</style>
</head>
<body>

<div id="preloader"><div></div></div>

<div class="login-container">
    <h2>Login</h2>
    <form method="POST" id="loginForm">
        <input type="email" name="email" placeholder="Email Address" required>
        <input type="password" name="password" placeholder="Password" required>
        <button type="submit">Login</button>
    </form>
    <p class="register-link">Don't have an account? <a href="register.php" style="color:black;">Register</a></p>
</div>

<script>
const form = document.getElementById('loginForm');
const preloader = document.getElementById('preloader');

form.addEventListener('submit', function() {
    preloader.style.display = 'flex';
});
</script>

<?php if(!empty($success)): ?>
<script>
Swal.fire({
    icon: 'success',
    title: 'Success!',
    html: '<?php echo $success; ?>',
    showConfirmButton: false,
    timer: 2000,
    timerProgressBar: true,
    didClose: () => { window.location.href = '<?php echo $_SESSION['dashboard']; ?>'; }
});
</script>
<?php endif; ?>

<?php if(!empty($error)): ?>
<script>
Swal.fire({
    icon: 'error',
    title: 'Oops!',
    html: '<?php echo $error; ?>',
    showConfirmButton: true
});
</script>
<?php endif; ?>

</body>
</html>
