<!DOCTYPE html>
<html lang="en">

  <head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Primary Meta Tags -->
<meta name="title" content="Activ8Hub — Digital Skills Training Hub in Awka">
<meta name="description" content="Activ8Hub is a digital skills training hub in Awka offering hands-on training in web development, graphics design, data analysis, digital marketing and more. Learn tech skills, build real projects, and grow your career with expert instructors.">

<!-- Keywords -->
<meta name="keywords" content="Activ8Hub, digital skills training Awka, tech hub Awka, learn web development Awka, digital marketing training, graphics design course, data analysis training, tech school in Awka, coding classes, ICT training center">

<!-- Robots -->
<meta name="robots" content="index, follow">
<meta name="googlebot" content="index, follow">

<!-- Language -->
<meta name="language" content="English">

<!-- Author -->
<meta name="author" content="Activ8Hub">

<!-- Theme Color (for mobile browsers) -->
<meta name="theme-color" content="#5D1B01">

<!-- Open Graph / Facebook -->
<meta property="og:type" content="website">
<meta property="og:title" content="Activ8Hub — Digital Skills Training Hub in Awka">
<meta property="og:description" content="Learn digital skills in Awka with hands-on training in web development, graphics design, data analysis, digital marketing, and more. Build real tech skills with Activ8Hub.">
<meta property="og:image" content="https://yourwebsite.com/activ8hub-banner.jpg">
<meta property="og:url" content="https://activ8hub.com">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Activ8Hub — Digital Skills Training Hub in Awka">
<meta name="twitter:description" content="Join Activ8Hub to learn practical digital skills including web development, graphics design, data analysis and more. Located in Awka.">
<meta name="twitter:image" content="https://yourwebsite.com/activ8hub-banner.jpg">

    <link href="https://fonts.googleapis.com/css?family=Montserrat:100,200,300,400,500,600,700,800,900" rel="stylesheet">

    <title> No Code School</title>
   
    <!-- Bootstrap core CSS -->
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">

    <!-- Additional CSS Files -->
    <link rel="stylesheet" href="assets/css/fontawesome.css">
    <link rel="stylesheet" href="assets/css/templatemo-grad-school.css">
    <link rel="stylesheet" href="assets/css/owl.css">
    <link rel="stylesheet" href="assets/css/lightbox.css">

  </head>

<body>

   
  <!--header-->
  <header class="main-header clearfix " role="header">
    <div class="logo">
  <a href="#">
    <img src="assets/images/Activ8-Hub-logo.png" alt="Activ8Hub Logo" style="height: 100px;">
  </a>
</div>

    <a href="#menu" class="menu-link"><i class="fa fa-bars"></i></a>
    <nav id="menu" class="main-nav" role="navigation">
      <ul class="main-menu" >
        <li><a href="#section1">Home</a></li>
        <li class="has-submenu"><a href="#section2">About Us</a>
          <ul class="sub-menu">
            <li><a href="#section2">Who we are?</a></li>
            <li><a href="#section3">What we do?</a></li>
            <li><a href="#section3">How it works?</a></li>
            </ul>
        </li>
        <li><a href="#section4">Courses</a></li>
        <!-- <li><a href="#section5">Video</a></li> -->
        <li><a href="#section6">Contact</a></li>
         <!--<li><a href="login.php">Login</a></li>-->
         <!-- <li><a href="register.php">Register</a></li>-->
        
      </ul>
    </nav>
  </header>

  <!-- ***** Main Banner Area Start ***** -->
  <section class="section main-banner" id="top" data-section="section1">
      <video autoplay muted loop id="bg-video">
          <source src="assets/images/landing.mp4" type="video/mp4" />
      </video>

      <div class="video-overlay header-text">
          <div class="caption">
              <h6 > No-Code School</h6>
              <h2><em style="color:rgb(21,97,179);">Your</em> Classroom</h2>
              <div style="display: flex; gap: 15px; justify-content: center; margin-top: 20px;">
    <a href="register.php" style="padding: 12px 25px; background: rgb(22,34,57); color: white; text-decoration: none; border-radius: 6px; font-weight: bold; transition: 0.3s;">
        Register
    </a>
    <a href="login.php" style="padding: 12px 25px; background:rgb(21,97,179); color: rgb(22,34,57); text-decoration: none; border-radius: 6px; font-weight: bold; transition: 0.3s;">
        Login
    </a>
</div>

          </div>
      </div>
  </section>
  <!-- ***** Main Banner Area End ***** -->


  <section class="features">
  <div class="container">
    <div class="row">

      <!-- Feature 1 -->
      <div class="col-lg-4 col-12" style="background-color:rgb(21,97,179);">
        <div class="features-post" style="background-color:rgb(21,97,179);">
          <div class="features-content" style="background-color:rgb(21,97,179);">
            <div class="content-show" style="background-color:rgb(21,97,179);">
              <h4><i class="fa fa-pencil"></i>All Courses</h4>
            </div>
            <div class="content-hide" >
              <p>Access a wide range of digital skills courses including Web Development, Graphics Design, Data Analysis, Digital Marketing, UI/UX and more — all tailored to help beginners grow fast.</p>
              <p class="hidden-sm">Learn at your pace with structured lessons and practical projects.</p>
              <div class="scroll-to-section"><a href="#section2">Explore Courses</a></div>
            </div>
          </div>
        </div>
      </div>

      <!-- Feature 2 -->
      <div class="col-lg-4 col-12">
        <div class="features-post second-features">
          <div class="features-content" style="background-color:rgb(21,97,179);">
            <div class="content-show"style="background-color:rgb(21,97,179);">
              <h4><i class="fa fa-graduation-cap"></i>Virtual Classes</h4>
            </div>
            <div class="content-hide">
              <p>Can't come onsite? Activ8Hub offers online and virtual classes so you can learn from anywhere in Awka, Anambra, or beyond. Join live sessions or watch recorded lessons.</p>
              <p class="hidden-sm">Flexible learning designed to fit your schedule.</p>
              <div class="scroll-to-section"><a href="#section3">View Details</a></div>
            </div>
          </div>
        </div>
      </div>

      <!-- Feature 3 -->
      <div class="col-lg-4 col-12">
        <div class="features-post third-features">
          <div class="features-content" style="background-color:rgb(21,97,179);">
            <div class="content-show" style="background-color:rgb(21,97,179);">
              <h4><i class="fa fa-book"></i>Physical Training</h4>
            </div>
            <div class="content-hide">
              <p>Prefer in-person learning? Join our physical training sessions in Awka with experienced instructors who guide you step-by-step and help you build real practical skills.</p>
              <p class="hidden-sm">Connect, collaborate, and grow in a supportive tech community.</p>
              <div class="scroll-to-section"><a href="#section4">Read More</a></div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>


 <section class="section why-us" data-section="section2">
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <div class="section-heading">
          <h2>Why Choose Activ8Hub?</h2>
        </div>
      </div>
      <div class="col-md-12">
        <div id='tabs' style="color:rgb(21,97,179);">
          <ul>
            <li><a href='#tabs-1'>Practical Training</a></li>
            <li><a href='#tabs-2'>Experienced Instructors</a></li>
            <li><a href='#tabs-3'>Career Support</a></li>
          </ul>

          <section class='tabs-content'>

            <!-- Tab 1 -->
            <article id='tabs-1'>
              <div class="row">
                <div class="col-md-6">
                  <img src="assets/images/activ8image2.jpeg" alt="">
                </div>
                <div class="col-md-6">
                  <h4>Practical Digital Skills Training</h4>
                  <p>At Activ8Hub, we focus on <strong>hands-on learning</strong>. Every course—from web development and graphics design to data analysis and digital marketing—is built around real-world projects that help you learn by doing, not just watching.</p>
                  <p>Our goal is to equip you with the exact skills the tech industry needs today.</p>
                </div>
              </div>
            </article>

            <!-- Tab 2 -->
            <article id='tabs-2'>
              <div class="row">
                <div class="col-md-6">
                  <img src="assets/images/activateimage1.jpeg" alt="">
                </div>
                <div class="col-md-6">
                  <h4>Top-Level Instructors</h4>
                  <p>Learn from experienced professionals who have mastered their fields and understand how to teach beginners effectively. Our team is passionate about mentoring students, explaining concepts clearly, and guiding you step by step.</p>
                  <p>We don’t just teach — we inspire and support you throughout your learning journey.</p>
                </div>
              </div>
            </article>

            <!-- Tab 3 -->
            <article id='tabs-3'>
              <div class="row">
                <div class="col-md-6">
                  <img src="assets/images/activ8image3.jpeg" alt="">
                </div>
                <div class="col-md-6">
                  <h4>Career Growth & Community</h4>
                  <p>Activ8Hub is more than a training center — it’s a community. Students get access to group mentorship, internship pathways, networking opportunities, and guidance on building a tech career.</p>
                  <p>We help you grow from a learner to a confident digital professional.</p>
                </div>
              </div>
            </article>

          </section>
        </div>
      </div>
    </div>
  </div>
</section>


  <section class="section coming-soon" data-section="section3">
    <div class="container">
      <div class="row">
        <div class="col-md-7 col-xs-12">
          <div class="continer centerIt">
            <div>
             <h4>Take <em style="color:rgb(21,97,179);">any online course</em> and push yourself closer to your next big goal</h4>

              <div class="counter">

                <div class="days">
                  <div class="value">00</div>
                  <span style="color:rgb(21,97,179);">Days</span>
                </div>

                <div class="hours">
                  <div class="value">00</div>
                  <span style="color:rgb(21,97,179);">Hours</span>
                </div>

                <div class="minutes">
                  <div class="value">00</div>
                  <span style="color:rgb(21,97,179);">Minutes</span>
                </div>

                <div class="seconds">
                  <div class="value">00</div>
                  <span style="color:rgb(21,97,179);">Seconds</span>
                </div>

              </div>
            </div>
          </div>
        </div>
        <div class="col-md-5">
          <div class="right-content">
            <div class="top-content">
              <h6>Register your free account and <em>get immediate</em> access to online courses</h6>
            </div>
            <form id="contact" action="" method="get">
              <div class="row">
                <div class="col-md-12">
                  <fieldset>
                    <input name="name" type="text" class="form-control" id="name" placeholder="Your Name" required="">
                  </fieldset>
                </div>
                <div class="col-md-12">
                  <fieldset>
                    <input name="email" type="text" class="form-control" id="email" placeholder="Your Email" required="">
                  </fieldset>
                </div>
                <div class="col-md-12">
                  <fieldset>
                    <input name="phone-number" type="text" class="form-control" id="phone-number" placeholder="Your Phone Number" required="">
                  </fieldset>
                </div>
                <div class="col-md-12">
                  <fieldset>
                   <a href="register.php" id="form-submit" class="button">Get it now</a>

                  </fieldset>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="section courses" data-section="section4">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="section-heading">
                    <h2>Choose Your Course</h2>
                </div>
            </div>

            <style>
                /* ===============================
                   Course Shelf Styles
                =============================== */

                /* Carousel container */
                .owl-carousel .item {
                    padding: 15px; /* spacing between cards */
                }

                /* -------------------------------
                   Individual Course Card
                ------------------------------- */
                .course-card {
                    display: flex;
                    flex-direction: column;
                    height: 460px; /* fixed height for uniform shelf look */
                    background: #ffffff;
                    border-radius: 12px;
                    overflow: hidden;
                    transition: transform 0.3s ease, box-shadow 0.3s ease;
                    border: 1px solid #e0e0e0;
                }

                /* Hover effect */
                .course-card:hover {
                    transform: translateY(-8px);
                    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
                }

                /* Course Image */
                .course-card img {
                    height: 100%; /* full height to show the cover standing */
                    width: auto;
                    object-fit: contain;
                    border-bottom: 1px solid #e0e0e0;
                    display: block;
                    margin: 0 auto;
                }

                /* Card Content */
                .down-content {
                    padding: 20px;
                    display: flex;
                    flex-direction: column;
                    flex-grow: 1;
                    justify-content: space-between;
                }

                .down-content h4 {
                    font-size: 1.2rem;
                    margin-bottom: 8px;
                    font-weight: 600;
                    color: #333333;
                }

                .course-desc {
                    font-size: 0.95rem;
                    color: #666666;
                    height: 60px;
                    overflow: hidden;
                    margin-bottom: 12px;
                }

                /* Read More Button */
                .read-more-btn {
                    color: #f5a425;
                    font-weight: 600;
                    text-decoration: none;
                    transition: all 0.3s ease;
                    margin-bottom: 8px; /* space to price button */
                }

                .read-more-btn:hover {
                    transform: translateX(5px);
                    color: #c97f17;
                }

                /* Tutor Name */
                .author-name {
                    font-weight: bold;
                    color: #444;
                    margin-bottom: 8px;
                }

                /* Course Action Button (Pay / Free) */
                .text-button-pay a,
                .text-button-free a {
                    display: inline-block;
                    padding: 8px 12px;
                    border-radius: 6px;
                    font-weight: 600;
                    font-size: 0.95rem;
                    text-decoration: none;
                    transition: all 0.3s ease;
                }

                .text-button-pay a {
                    background-color: #f5a425;
                    color: black;
                }

                .text-button-pay a:hover {
                    background-color: #c97f17;
                }

                .text-button-free a {
                    background-color: #6c757d;
                    color: black;
                }

                .text-button-free a:hover {
                    background-color: black;
                }

                /* Mobile Adjustments */
                @media (max-width: 767px) {
                    .course-card {
                        height: auto;
                    }

                    .course-desc {
                        height: auto;
                        margin-bottom: 10px;
                    }

                    .read-more-btn {
                        margin-bottom: 12px;
                    }
                }
            </style>

            <div class="owl-carousel owl-theme">
               <?php
                include "user/db.php";

                // Select up to 5 random courses
                $stmt = $conn->prepare("SELECT * FROM courses ORDER BY RAND() LIMIT 5");
                $stmt->execute();
                $result = $stmt->get_result();

                while ($course = $result->fetch_assoc()):
                    $coverFile = 'uploads/covers/' . basename($course['cover']);
                    $absoluteCover = __DIR__ . '/' . $coverFile;
                    $cover = file_exists($absoluteCover) ? $coverFile : 'uploads/covers/default-course.jpg';
                    $title = htmlspecialchars($course['title']);
                    $tutor = htmlspecialchars($course['tutor']);
                    $short_desc = htmlspecialchars(mb_substr($course['description'], 0, 70)) . "...";
                    $btn_class = ($course['price'] > 0) ? 'text-button-pay' : 'text-button-free';
                    $btn_text  = ($course['price'] > 0) ? "Pay ₦" . number_format($course['price'], 2) : "Free";
               ?>

                <div class="item">
                    <div class="course-card">
                        <img src="<?php echo $cover; ?>" alt="<?php echo $title; ?>">

                        <div class="down-content">
                            <h4><?php echo $title; ?></h4>
                            <p class="course-desc"><?php echo $short_desc; ?></p>

                            <a class="read-more-btn" href="course.php?id=<?php echo $course['id']; ?>" style="color:rgb(21,97,179);">
                                VIEW COURSE →
                            </a>

                            <!--<div class="author-name"><?php echo $tutor; ?></div>-->

                            <!--<div class="<?php echo $btn_class; ?>">-->
                            <!--    <a href="course.php?id=<?php echo $course['id']; ?>">-->
                            <!--        <?php echo $btn_text; ?> <i class="fa fa-angle-double-right"></i>-->
                            <!--    </a>-->
                            <!--</div>-->
                        </div>
                    </div>
                </div>

                <?php endwhile; $stmt->close(); ?>
            </div>

            <script>
                $(document).ready(function(){
                    $(".owl-carousel").owlCarousel({
                        loop: false,
                        margin: 20,
                        nav: true,
                        dots: false,
                        items: 1, // show 1 course at a time
                        responsive:{
                            0:{ items:1 },
                            576:{ items:1 },
                            768:{ items:1 },
                            992:{ items:1 },
                            1200:{ items:1 }
                        }
                    });
                });
            </script>

        </div>
    </div>
</section>



  

  <section class="section video" data-section="section5">
  <div class="container">
    <div class="row">

      <!-- Left Text Section -->
      <div class="col-md-6 align-self-center">
        <div class="left-content">
          <span>Discover what we offer</span>
          <h4>Watch this video to learn more <em style="color:rgb(21,97,179);">about Activ8Hub</em></h4>
          <p>Get a quick look into how Activ8Hub helps students learn practical digital skills such as web development, graphics design, data analysis, and more. Our goal is to empower beginners and professionals with hands-on, real-world training.</p>
          <p class="hidden-sm">At Activ8Hub, we believe in learning by doing — and our programs are designed to help you grow faster.</p>

          <div class="main-button">
            <a href="#courses" style="background-color:rgb(21,97,179);">Explore Our Courses</a>
          </div>
        </div>
      </div>

      <!-- Video Section -->
      <div class="col-md-6">
        <article class="video-item">
          <div class="video-caption">
            <h4>Inside Activ8Hub</h4>
          </div>
         <figure>
  <iframe 
    width="328" 
    height="583"
    src="https://www.youtube.com/embed/GFJ3knDoUd0"
    title="YouTube Shorts Video"
    frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
</figure>

        </article>
      </div>

    </div>
  </div>
</section>


  <section class="section contact" data-section="section6">
  <div class="container">
    <div class="row">

      <div class="col-md-12">
        <div class="section-heading">
          <h2>Let’s Keep In Touch</h2>
        </div>
      </div>

      <!-- Contact Form -->
     <div class="col-md-6">
  <form id="contact" onsubmit="sendEmail(event)">
    <div class="row">
      <div class="col-md-6">
        <fieldset>
          <input name="name" type="text" class="form-control" id="name" placeholder="Your Name" required>
        </fieldset>
      </div>
      <div class="col-md-6">
        <fieldset>
          <input name="email" type="email" class="form-control" id="email" placeholder="Your Email" required>
        </fieldset>
      </div>
      <div class="col-md-12">
        <fieldset>
          <textarea name="message" rows="6" class="form-control" id="message" placeholder="Your Message..." required></textarea>
        </fieldset>
      </div>
      <div class="col-md-12">
        <fieldset>
          <button type="submit" id="form-submit" class="button" style="background-color:rgb(21,97,179);">Send Message</button>
        </fieldset>
      </div>
    </div>
  </form>
</div>

<script>
function sendEmail(event) {
  event.preventDefault(); // Prevent form from submitting normally

  const name = encodeURIComponent(document.getElementById('name').value);
  const email = encodeURIComponent(document.getElementById('email').value);
  const message = encodeURIComponent(document.getElementById('message').value);

  const mailtoLink = `mailto:activ8techhub@gmail.com?subject=Contact Form Submission&body=Name: ${name}%0AEmail: ${email}%0A%0AMessage:%0A${message}`;

  window.location.href = mailtoLink; // Open email client
}
</script>

      <!-- Map -->
      <div class="col-md-6">
        <div id="map">
          <iframe src="https://maps.google.com/maps?q=Awka,%20Anambra%20State&t=&z=13&ie=UTF8&iwloc=&output=embed"
            width="100%" height="422px" frameborder="0" style="border:0" allowfullscreen></iframe>
        </div>
      </div>

    </div>
  </div>
</section>

  <footer>
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <p>
          © 2025 Activ8Hub — Digital Skills Training Hub, Awka.<br>
          Designed & Developed by Activ8Hub Team.
        </p>
      </div>
    </div>
  </div>
</footer>


  <!-- Scripts -->
  <!-- Bootstrap core JavaScript -->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <script src="assets/js/isotope.min.js"></script>
    <script src="assets/js/owl-carousel.js"></script>
    <script src="assets/js/lightbox.js"></script>
    <script src="assets/js/tabs.js"></script>
    <script src="assets/js/video.js"></script>
    <script src="assets/js/slick-slider.js"></script>
    <script src="assets/js/custom.js"></script>
    <script>
        //according to loftblog tut
        $('.nav li:first').addClass('active');

        var showSection = function showSection(section, isAnimate) {
          var
          direction = section.replace(/#/, ''),
          reqSection = $('.section').filter('[data-section="' + direction + '"]'),
          reqSectionPos = reqSection.offset().top - 0;

          if (isAnimate) {
            $('body, html').animate({
              scrollTop: reqSectionPos },
            800);
          } else {
            $('body, html').scrollTop(reqSectionPos);
          }

        };

        var checkSection = function checkSection() {
          $('.section').each(function () {
            var
            $this = $(this),
            topEdge = $this.offset().top - 80,
            bottomEdge = topEdge + $this.height(),
            wScroll = $(window).scrollTop();
            if (topEdge < wScroll && bottomEdge > wScroll) {
              var
              currentId = $this.data('section'),
              reqLink = $('a').filter('[href*=\\#' + currentId + ']');
              reqLink.closest('li').addClass('active').
              siblings().removeClass('active');
            }
          });
        };

        $('.main-menu, .scroll-to-section').on('click', 'a', function (e) {
          if($(e.target).hasClass('external')) {
            return;
          }
          e.preventDefault();
          $('#menu').removeClass('active');
          showSection($(this).attr('href'), true);
        });

        $(window).scroll(function () {
          checkSection();
        });
    </script>
    
    
</body>
</html>