<!-- ================= PM ADMIN SIDEBAR (ALL-IN-ONE) ================= -->

<style>
  /* ===== PM SIDEBAR CORE ===== */
  .pm-sidebar {
    width: 16rem;
    background: #ffffff;
    border-right: 1px solid #e5e7eb;
    transition: transform 0.3s ease;
  }

  .dark .pm-sidebar {
    background: #0f172a;
    border-color: #1e293b;
  }

  .pm-sidebar-header {
    border-bottom: 1px solid #e5e7eb;
  }

  .dark .pm-sidebar-header {
    border-color: #1e293b;
  }

  /* ===== NAV LINKS ===== */
  .pm-nav-link {
    display: block;
    padding: 0.65rem 0.75rem;
    border-radius: 0.6rem;
    font-size: 0.875rem;
    color: #334155;
    transition: background 0.2s ease, color 0.2s ease;
  }

  .pm-nav-link:hover {
    background: #f1f5f9;
  }

  .dark .pm-nav-link {
    color: #cbd5f5;
  }

  .dark .pm-nav-link:hover {
    background: #1e293b;
  }

  .pm-active {
    background: rgba(79, 70, 229, 0.1);
    color: #4f46e5;
    font-weight: 500;
  }

  .dark .pm-active {
    background: rgba(79, 70, 229, 0.15);
  }

  /* ===== OVERLAY ===== */
  .pm-overlay {
    background: rgba(0, 0, 0, 0.4);
  }
</style>

<!-- SIDEBAR -->
<aside
  id="pm-sidebar"
  class="pm-sidebar fixed md:relative inset-y-0 left-0 z-40
         shadow-xl md:shadow-none
         transform -translate-x-full md:translate-x-0">

  <div class="flex flex-col h-full">

    <!-- Header -->
    <div class="pm-sidebar-header flex items-center gap-3 px-5 py-4">
      <div
        class="w-10 h-10 rounded-xl bg-indigo-600 text-white
               flex items-center justify-center font-bold">
        PM
      </div>
      <div class="leading-tight">
        <h2 class="text-sm font-semibold text-slate-800 dark:text-slate-100">
          Admin Panel
        </h2>
        <p class="text-xs text-slate-500 dark:text-slate-400">
          Dashboard
        </p>
      </div>
    </div>

    <!-- Navigation -->
    <nav class="flex-1 px-3 py-4 space-y-1">
      <a href="#" class="pm-nav-link pm-active">Dashboard</a>
      <a href="courses.php" class="pm-nav-link">Courses</a>
      <a href="announcements.php" class="pm-nav-link">Announcements</a>
      <a href="messages.php" class="pm-nav-link">Messages</a>
      <a href="users.php" class="pm-nav-link">Students</a>
      <a href="payments.php" class="pm-nav-link">Purchases</a>
      <a href="#" class="pm-nav-link">Settings</a>
    </nav>

    <!-- Footer -->
    <div class="px-4 py-4 border-t border-slate-200 dark:border-slate-800">
      <form method="post" action="../logout.php">
        <button
          type="submit"
          class="w-full py-2 rounded-lg text-sm font-medium
                 bg-slate-100 dark:bg-slate-800
                 hover:bg-slate-200 dark:hover:bg-slate-700
                 transition">
          Logout
        </button>
      </form>
    </div>

  </div>
</aside>

<!-- Overlay -->
<div
  id="pm-sidebar-overlay"
  class="pm-overlay fixed inset-0 z-30 hidden md:hidden">
</div>

<script>
  (function () {
    const sidebar = document.getElementById("pm-sidebar");
    const overlay = document.getElementById("pm-sidebar-overlay");
    const menuBtn = document.getElementById("menuBtn"); // your toggle button

    if (menuBtn) {
      menuBtn.addEventListener("click", () => {
        sidebar.classList.toggle("-translate-x-full");
        overlay.classList.toggle("hidden");
      });
    }

    if (overlay) {
      overlay.addEventListener("click", () => {
        sidebar.classList.add("-translate-x-full");
        overlay.classList.add("hidden");
      });
    }
  })();
</script>

<!-- ================= END PM SIDEBAR ================= -->
