<?php
session_start();
include "../user/db.php";
include "back.php";

// Protect admin page
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../login.php");
    exit;
}


// Fetch all payments
$query = $conn->query("
    SELECT 
        id, user_id, fullname, course_id, reference, amount, created_at
    FROM user_payments
    ORDER BY created_at DESC
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>All Payments</title>

<style>
:root {
    --bg: #f5f7fb;
    --card: #ffffff;
    --text: #222;
    --muted: #6b7280;
    --primary: #6c4eff;
    --accent1: #16a34a;
    --accent2: #2563eb;
    --accent3: #9333ea;
    --border: #e5e7eb;
}

body.dark {
    --bg: #0f172a;
    --card: #111827;
    --text: #f1f5f9;
    --muted: #9ca3af;
    --border: #1f2937;
}

* {
    box-sizing: border-box;
    font-family: "Segoe UI", sans-serif;
}

body {
    margin: 0;
    background: var(--bg);
    color: var(--text);
    min-height: 100vh;
    display: flex;
    flex-direction: column;
}

/* ===== TOP BAR ===== */
.topbar {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 14px 18px;
    background: var(--card);
    border-bottom: 1px solid var(--border);
    position: sticky;
    top: 0;
    z-index: 100;
}

.back-btn {
    font-size: 20px;
    cursor: pointer;
    color: var(--primary);
}

.topbar h2 {
    margin: 0;
    font-size: 18px;
}

/* ICON TOGGLE */
.toggle {
    cursor: pointer;
    background: var(--primary);
    color: #fff;
    border: none;
    width: 38px;
    height: 38px;
    border-radius: 50%;
    font-size: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* ===== PAGE ===== */
.container {
    padding: 18px;
    flex: 1;
}

/* ===== TABLE ===== */
.table-wrap {
    background: var(--card);
    border-radius: 12px;
    overflow-x: auto;
    border: 1px solid var(--border);
}

table {
    width: 100%;
    border-collapse: collapse;
    min-width: 850px;
}

th, td {
    padding: 13px 15px;
    text-align: left;
    border-bottom: 1px solid var(--border);
    font-size: 14px;
}

th {
    background: var(--bg);
    font-weight: 600;
    color: var(--muted);
}

/* MULTI-COLOR WRITEUPS */
.user-id { color: var(--accent2); font-weight: 600; }
.fullname { color: var(--accent3); font-weight: 600; }
.course { color: #f97316; font-weight: 600; }
.reference { color: var(--muted); font-size: 13px; }
.amount { color: var(--accent1); font-weight: 700; }

/* ===== FOOTER ===== */
.footer {
    background: var(--card);
    border-top: 1px solid var(--border);
    padding: 12px 18px;
    text-align: center;
    font-size: 13px;
    color: var(--muted);
}

/* ===== MOBILE ===== */
@media (max-width: 768px) {
    .topbar h2 {
        font-size: 16px;
    }

    table {
        min-width: 750px;
    }
}
</style>
</head>

<body>

<!-- TOP BAR -->
<div class="topbar">
    <!--<span class="back-btn" onclick="history.back()">←</span>-->
    <h2>Users Payments</h2>
    <button class="toggle" onclick="toggleTheme()" id="themeIcon">🌙</button>
</div>

<!-- CONTENT -->
<div class="container">
    <div class="table-wrap">
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>User ID</th>
                    <th>Full Name</th>
                    <th>Course ID</th>
                    <th>Reference</th>
                    <th>Amount (₦)</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($query->num_rows > 0): ?>
                    <?php $i = 1; while ($row = $query->fetch_assoc()): ?>
                        <tr>
                            <td><?= $i++ ?></td>
                            <td class="user-id"><?= htmlspecialchars($row['user_id']) ?></td>
                            <td class="fullname"><?= htmlspecialchars($row['fullname']) ?></td>
                            <td class="course"><?= htmlspecialchars($row['course_id']) ?></td>
                            <td class="reference"><?= htmlspecialchars($row['reference']) ?></td>
                            <td class="amount">₦<?= number_format($row['amount'], 2) ?></td>
                            <td><?= date("d M Y · h:i A", strtotime($row['created_at'])) ?></td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" style="text-align:center; padding:20px;">
                            No payments found
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>



<script>
function toggleTheme() {
    document.body.classList.toggle('dark');
    const icon = document.getElementById('themeIcon');
    icon.textContent = document.body.classList.contains('dark') ? '☀️' : '🌙';
}
</script>

</body>
</html><br><br><br>
<?php
include "footer.php";
?>
