<?php
session_start();
include "../user/db.php";
include "back.php";

// Protect admin page
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../login.php");
    exit;
}

/* FETCH ALL MESSAGES + REPLY COUNT */
$query = "
SELECT sm.*, COUNT(r.id) AS reply_count
FROM student_messages sm
LEFT JOIN student_message_replies r ON sm.id = r.message_id
GROUP BY sm.id
ORDER BY sm.created_at DESC
";
$messages = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin | Student Messages</title>

<style>
/* ================= ADMIN MESSAGE UI (ISOLATED) ================= */
.admin-msg-wrap {
    max-width: 1000px;
    margin: 30px auto;
    font-family: "Segoe UI", sans-serif;
    color: #fff;
    
}

.admin-msg-wrap h2 {
    color: rgb(245,164,37);
    margin-bottom: 25px;
    font-weight: 600;
}

/* Message Card */
.admin-msg-card {
    background: rgb(23,35,57);
    border-radius: 14px;
    padding: 18px 20px;
    margin-bottom: 22px;
    box-shadow: 0 6px 18px rgba(0,0,0,0.25);
}

/* Header */
.admin-msg-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 15px;
    flex-wrap: wrap;
}

.admin-msg-title {
    font-size: 1.05rem;
    font-weight: 600;
    color: rgb(245,164,37);
}

.admin-msg-meta {
    font-size: 0.8rem;
    color: #bdbdbd;
    white-space: nowrap;
}

/* Message Body */
.admin-msg-body {
    margin-top: 12px;
    line-height: 1.65;
    font-size: 0.95rem;
    color: #eaeaea;
}

/* Replies Section */
.admin-msg-replies {
    margin-top: 18px;
    padding-top: 14px;
    border-top: 1px solid #334;
}

.admin-msg-replies strong {
    font-size: 0.9rem;
    color: #ddd;
}

/* Single Reply */
.admin-reply {
    background: #2a2a44;
    padding: 10px 12px;
    border-radius: 10px;
    margin-bottom: 8px;
    font-size: 0.9rem;
    line-height: 1.5;
}

.admin-reply small {
    display: block;
    margin-top: 4px;
    color: #aaa;
    font-size: 0.75rem;
}

/* No Reply */
.admin-no-reply {
    color: #aaa;
    font-style: italic;
    font-size: 0.85rem;
    margin-bottom: 10px;
}

/* Reply Form */
.admin-reply-form {
    margin-top: 10px;
}

.admin-reply-form textarea {
    width: 100%;
    resize: none;
    padding: 10px 12px;
    border-radius: 10px;
    border: 1px solid #444;
    background: #111b24;
    color: #fff;
    font-size: 0.9rem;
    line-height: 1.5;
    box-sizing: border-box;
}

.admin-reply-form textarea:focus {
    outline: none;
    border-color: rgb(245,164,37);
}

/* Button */
.admin-reply-form button {
    margin-top: 8px;
    padding: 9px 18px;
    border-radius: 20px;
    border: none;
    background: rgb(245,164,37);
    color: #000;
    font-weight: 600;
    font-size: 0.85rem;
    cursor: pointer;
}

.admin-reply-form button:hover {
    opacity: 0.9;
}

/* Responsive */
@media (max-width: 768px) {
    .admin-msg-card {
        padding: 15px;
    }

    .admin-msg-title {
        font-size: 1rem;
    }

    .admin-msg-body {
        font-size: 0.9rem;
    }
}
</style>
</head>

<body style="background: rgb(23,35,57);">

<div class="admin-msg-wrap">
    <h2>Student Messages</h2>

    <?php while ($msg = $messages->fetch_assoc()): ?>

    <div class="admin-msg-card">
        <div class="admin-msg-header">
            <div class="admin-msg-title">
                <?= htmlspecialchars($msg['title']) ?>
            </div>
            <div class="admin-msg-meta">
                <?= date("d M Y  h:i A", strtotime($msg['created_at'])) ?> |
                <?= $msg['reply_count'] ?> Reply<?= $msg['reply_count'] != 1 ? 'ies' : '' ?>
            </div>
        </div>

        <div class="admin-msg-body">
            <?= nl2br(htmlspecialchars($msg['message'])) ?>
        </div>

        <div class="admin-msg-replies">
            <strong>Replies</strong><br><br>

            <?php
            $rid = (int)$msg['id'];
            $replies = $conn->query("
                SELECT reply, created_at
                FROM student_message_replies
                WHERE message_id = $rid
                ORDER BY created_at ASC
            ");
            ?>

            <?php if ($replies->num_rows > 0): ?>
                <?php while ($r = $replies->fetch_assoc()): ?>
                    <div class="admin-reply">
                        <?= nl2br(htmlspecialchars($r['reply'])) ?>
                        <small><?= date("d M Y  h:i A", strtotime($r['created_at'])) ?></small>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <p class="admin-no-reply">No reply yet</p>
            <?php endif; ?>

            <form class="admin-reply-form" method="POST" action="reply_message.php">
                <input type="hidden" name="message_id" value="<?= $msg['id'] ?>">
                <textarea name="reply" rows="3" placeholder="Write a reply" required></textarea>
                <button type="submit">Send Reply</button>
            </form>
        </div>
    </div>

    <?php endwhile; ?>
</div>

</body>
</html>
<?php
include "footer.php"
?>
