<?php
session_start();

/*
 |-----------------------------------------
 | Securely destroy all session data
 |-----------------------------------------
*/
$_SESSION = [];

if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(
        session_name(),
        '',
        time() - 42000,
        $params["path"],
        $params["domain"],
        $params["secure"],
        $params["httponly"]
    );
}

session_destroy();

/*
 |-----------------------------------------
 | Redirect after logout
 |-----------------------------------------
*/
header("Location: ../login.php"); // adjust path if needed
exit;
