<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">


<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>
    * {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
  font-family: "Segoe UI", sans-serif;
}

.admin-header {
  width: 100%;
  height: 65px;
  background: #0f172a;
  color: #fff;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 20px;
  position: sticky;
  top: 0;
  z-index: 1000;
}

/* LEFT */
.left {
  display: flex;
  align-items: center;
  gap: 15px;
}

.logo {
  font-size: 20px;
  font-weight: 600;
}

.menu-btn {
  background: none;
  border: none;
  color: #fff;
  font-size: 22px;
  cursor: pointer;
  display: none;
}

/* RIGHT */
.right {
  display: flex;
  align-items: center;
  gap: 20px;
}

.search-box {
  display: flex;
  align-items: center;
  background: #1e293b;
  padding: 6px 10px;
  border-radius: 8px;
}

.search-box input {
  background: transparent;
  border: none;
  outline: none;
  color: #fff;
  margin-left: 8px;
  width: 150px;
}

.profile {
  display: flex;
  align-items: center;
  gap: 8px;
  cursor: pointer;
  position: relative;
}

.profile img {
  width: 36px;
  height: 36px;
  border-radius: 50%;
}

/* DROPDOWN */
.dropdown {
  position: absolute;
  top: 55px;
  right: 0;
  background: #fff;
  color: #000;
  width: 180px;
  border-radius: 8px;
  box-shadow: 0 10px 25px rgba(0,0,0,0.2);
  display: none;
}

.dropdown a {
  display: block;
  padding: 12px 15px;
  color: #000;
  text-decoration: none;
  font-size: 14px;
}

.dropdown a:hover {
  background: #f1f5f9;
}

/* RESPONSIVE */
@media (max-width: 768px) {
  .menu-btn {
    display: block;
  }

  .search-box {
    display: none;
  }

  .profile span {
    display: none;
  }
}
/*logo*/

.left {
  display: flex;
  align-items: center;
}

.logo-img {
  height: 100px;      /* desktop */
  width: auto;
  object-fit: contain;
}

/* Tablet */
@media (max-width: 768px) {
  .logo-img {
   height: 100px; 
  }
}

/* Mobile */
@media (max-width: 480px) {
  .logo-img {
   height: 100px; 
  }
}

</style>
</head>
<body>

<header class="admin-header">
 <div class="left">
  <img src="../assets/images/Activ8-Hub-logo.png" alt="Admin Panel Logo" class="logo-img">
</div>

  <div class="right">
    <div class="search-box">
      <i class="fas fa-search"></i>
      <input type="text" placeholder="Search...">
    </div>

    <div class="profile" onclick="toggleProfile()">
      <img src="https://i.pravatar.cc/40" alt="Admin">
      <span>Admin</span>
      <i class="fas fa-chevron-down"></i>

      <div class="dropdown" id="profileMenu">
        <a href="#"><i class="fas fa-user"></i> Profile</a>
        <a href="#"><i class="fas fa-cog"></i> Settings</a>
        <a href="#"><i class="fas fa-sign-out-alt"></i> Logout</a>
      </div>
    </div>
  </div>
</header>

<script>
    function toggleProfile() {
  const menu = document.getElementById("profileMenu");
  menu.style.display = menu.style.display === "block" ? "none" : "block";
}

function toggleMenu() {
  alert("Sidebar toggle here");
}

/* Close dropdown when clicking outside */
document.addEventListener("click", function (e) {
  const profile = document.querySelector(".profile");
  const menu = document.getElementById("profileMenu");

  if (!profile.contains(e.target)) {
    menu.style.display = "none";
  }
});

</script>
</body>
</html>
