<?php
// admin_course_outlines.php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
include "../user/db.php";
include "back.php";

// Protect admin page
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../login.php");
    exit;
}

// Delete record if requested
if (isset($_GET['delete_id'])) {
    $del_id = intval($_GET['delete_id']);
    $stmt = $conn->prepare("DELETE FROM course_outline_downloads WHERE id=?");
    $stmt->bind_param("i", $del_id);
    $stmt->execute();
    $stmt->close();
    header("Location: admin_course_outlines.php");
    exit;
}

// Fetch all downloads
$query = "
    SELECT cod.id, c.title AS course_title, cod.full_name, cod.email, cod.phone, cod.downloaded_at
    FROM course_outline_downloads cod
    JOIN courses c ON cod.course_id = c.id
    ORDER BY cod.downloaded_at DESC
";
$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin - Course Outline Downloads</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>
:root {
    --bg-color: rgb(23,34,57);
    --accent-color: rgb(245,164,37);
    --text-color: white;
    --hover-bg: rgba(245,164,37,0.2);
}

body {
    font-family: Arial, sans-serif;
    background: var(--bg-color);
    color: var(--text-color);
    margin: 0;
    padding: 20px;
}

h1 {
    text-align: center;
    margin-bottom: 20px;
    color: var(--accent-color);
}

table {
    width: 100%;
    border-collapse: collapse;
    background: var(--bg-color);
}

th, td {
    padding: 12px 15px;
    text-align: left;
    border: 1px solid var(--accent-color);
}

th {
    background-color: var(--accent-color);
    color: var(--bg-color);
    text-transform: uppercase;
}

tr:nth-child(even) {
    background-color: rgba(255,255,255,0.05);
}

tr:hover {
    background-color: var(--hover-bg);
}

.delete-btn {
    color: #ff4d4f;
    text-decoration: none;
    font-weight: bold;
}

.delete-btn:hover {
    text-decoration: underline;
}

@media(max-width:768px){
    table, thead, tbody, th, td, tr {
        display: block;
        width: 100%;
    }
    tr {
        margin-bottom: 15px;
        border-bottom: 2px solid var(--accent-color);
    }
    th {
        display: none;
    }
    td {
        display: flex;
        justify-content: space-between;
        padding: 10px 5px;
        border: none;
        border-bottom: 1px solid rgba(255,255,255,0.2);
    }
    td:before {
        content: attr(data-label);
        font-weight: bold;
        color: var(--accent-color);
    }
}
</style>
</head>
<body>

<h1>Course Outline Downloads</h1>

<table>
<thead>
<tr>
    <th>no</th>
    <th>Course</th>
    <th>Full Name</th>
    <th>Email</th>
    <th>Phone</th>
    <th>Date</th>
    <th>Action</th>
</tr>
</thead>
<tbody>
<?php
if ($result->num_rows > 0) {
    $i = 1;
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td data-label='S/N'>{$i}</td>";
        echo "<td data-label='Course'>".htmlspecialchars($row['course_title'])."</td>";
        echo "<td data-label='Full Name'>".htmlspecialchars($row['full_name'])."</td>";
        echo "<td data-label='Email'>".htmlspecialchars($row['email'])."</td>";
        echo "<td data-label='Phone'>".htmlspecialchars($row['phone'])."</td>";
        echo "<td data-label='Date'>{$row['downloaded_at']}</td>";
        echo "<td data-label='Action'><a class='delete-btn' href='?delete_id={$row['id']}' onclick='return confirm(\"Are you sure?\")'>Delete</a></td>";
        echo "</tr>";
        $i++;
    }
} else {
    echo "<tr><td colspan='7' style='text-align:center'>No downloads yet</td></tr>";
}
?>
</tbody>
</table>

</body>
</html>
